/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import scala.actors.threadpool.Arrays;

public class MazeGenerator {
    int width = 0;
    int height = 0;
    long seed = 0L;
    Random rand = null;
    int[][] grid;
    static final int N = 1;
    static final int S = 2;
    static final int E = 4;
    static final int W = 8;
    static final int U = 16;
    public static HashMap<Integer, String[]> tiles = new HashMap();

    int getOPP(int in) {
        switch (in) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 4;
            }
        }
        return -99;
    }

    int getDX(int in) {
        switch (in) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return -1;
            }
        }
        return -99;
    }

    int getDY(int in) {
        switch (in) {
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 8: {
                return 0;
            }
        }
        return -99;
    }

    int getCROSS(int in) {
        switch (in) {
            case 1: {
                return 12;
            }
            case 2: {
                return 12;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 3;
            }
        }
        return -99;
    }

    public MazeGenerator(int width, int height, long seed) {
        this.width = width;
        this.height = height;
        this.seed = seed;
        this.rand = new Random(seed);
        this.grid = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.grid[y][x] = 0;
            }
        }
    }

    public void generate() {
        ArrayList<Loc> cells = new ArrayList<Loc>();
        int l = (this.width + this.height) / 4;
        for (int z = 0; z < l; ++z) {
            int w = 1 + this.rand.nextInt(3);
            if (w > 2) {
                --l;
            }
            int qq = this.rand.nextInt(this.width - w);
            int ww = this.rand.nextInt(this.height - w);
            for (int a = qq; a < qq + w; ++a) {
                for (int b = ww; b < ww + w; ++b) {
                    this.grid[b][a] = -1;
                }
            }
        }
        int xx = 1 + this.width / 2;
        int yy = 1 + this.height / 2;
        while (this.grid[yy][xx] == -1) {
            xx = this.rand.nextInt(this.width);
            yy = this.rand.nextInt(this.height);
        }
        cells.add(new Loc(xx, yy));
        List directions = Arrays.asList((Object[])new Integer[]{1, 2, 4, 8});
        while (!cells.isEmpty()) {
            int index = this.getNextIndex(cells.size());
            int x = ((Loc)cells.get((int)index)).x;
            int y = ((Loc)cells.get((int)index)).y;
            Collections.shuffle(directions, this.rand);
            boolean carved = false;
            Iterator i$ = directions.iterator();
            while (i$.hasNext()) {
                int dir = (Integer)i$.next();
                int nx = x + this.getDX(dir);
                int ny = y + this.getDY(dir);
                if (0 >= nx || nx >= this.width - 1 || 0 >= ny || ny >= this.height - 1) continue;
                if (this.grid[ny][nx] == 0) {
                    int[] nArray = this.grid[y];
                    int n = x;
                    nArray[n] = nArray[n] | dir;
                    int[] nArray2 = this.grid[ny];
                    int n2 = nx;
                    nArray2[n2] = nArray2[n2] | this.getOPP(dir);
                    cells.add(new Loc(nx, ny));
                    carved = true;
                } else if (this.canWeave(dir, nx, ny)) {
                    int[] nArray = this.grid[y];
                    int n = x;
                    nArray[n] = nArray[n] | dir;
                    if (this.rand.nextBoolean()) {
                        int[] nArray3 = this.grid[ny];
                        int n3 = nx;
                        nArray3[n3] = nArray3[n3] | 0x10;
                    } else {
                        this.grid[ny][nx] = (this.grid[ny][nx] & 1) != 0 ? 28 : 19;
                    }
                    int[] nArray4 = this.grid[ny += this.getDY(dir)];
                    int n4 = nx += this.getDX(dir);
                    nArray4[n4] = nArray4[n4] | this.getOPP(dir);
                    cells.add(new Loc(nx, ny));
                    carved = true;
                }
                if (!carved) continue;
                break;
            }
            if (carved) continue;
            cells.remove(index);
        }
        int qq = 1 + this.width / 2;
        int ww = 1 + this.height / 2;
        Loc lt = new Loc(qq, ww);
        block6: while (this.grid[lt.y][lt.x] != 99) {
            while (this.grid[lt.y][lt.x] != -1) {
                Collections.shuffle(directions, this.rand);
                qq = this.rand.nextInt(this.width);
                ww = this.rand.nextInt(this.height);
                lt = new Loc(qq, ww);
            }
            Iterator i$ = directions.iterator();
            while (i$.hasNext()) {
                int dir = (Integer)i$.next();
                int nx = lt.x + this.getDX(dir);
                int ny = lt.y + this.getDY(dir);
                if (0 >= nx || nx >= this.width - 1 || 0 >= ny || ny >= this.height - 1 || this.grid[ny][nx] <= 0) continue;
                int[] nArray = this.grid[ny];
                int n = nx;
                nArray[n] = nArray[n] | this.getOPP(dir);
                this.grid[lt.y][lt.x] = 99;
                break block6;
            }
        }
    }

    private int getNextIndex(int ceil) {
        float r = this.rand.nextFloat();
        if (r <= 0.45f) {
            return ceil - 1;
        }
        if (r <= 0.9f) {
            return this.rand.nextInt(ceil);
        }
        return 0;
    }

    private boolean canWeave(int dir, int x, int y) {
        int cell = this.grid[y][x];
        if (cell != this.getCROSS(dir)) {
            return false;
        }
        int nx = x + this.getDX(dir);
        int ny = y + this.getDY(dir);
        return ny > 0 && ny < this.height - 1 && nx > 0 && nx < this.width - 1 && this.grid[ny][nx] == 0;
    }

    public void print() {
        for (Integer keys : tiles.keySet()) {
            System.out.print(keys + ",");
        }
        System.out.println();
        for (int y = 0; y < this.height; ++y) {
            for (int q = 0; q < 3; ++q) {
                for (int x = 0; x < this.width; ++x) {
                    if (tiles.containsKey(this.grid[y][x])) {
                        System.out.print(tiles.get(this.grid[y][x])[q]);
                        continue;
                    }
                    System.out.print("@@@");
                }
                System.out.println();
            }
        }
    }

    static {
        tiles.put(0, new String[]{"XXX", "XXX", "XXX"});
        tiles.put(99, new String[]{"$$$", "$ $", "$$$"});
        tiles.put(1, new String[]{"# #", "# #", "###"});
        tiles.put(2, new String[]{"###", "# #", "# #"});
        tiles.put(4, new String[]{"###", "#  ", "###"});
        tiles.put(8, new String[]{"###", "  #", "###"});
        tiles.put(3, new String[]{"# #", "# #", "# #"});
        tiles.put(9, new String[]{"# #", "  #", "###"});
        tiles.put(5, new String[]{"# #", "#  ", "###"});
        tiles.put(10, new String[]{"###", "  #", "# #"});
        tiles.put(6, new String[]{"###", "#  ", "# #"});
        tiles.put(12, new String[]{"###", "   ", "###"});
        tiles.put(7, new String[]{"# #", "#  ", "# #"});
        tiles.put(11, new String[]{"# #", "  #", "# #"});
        tiles.put(13, new String[]{"# #", "   ", "###"});
        tiles.put(14, new String[]{"###", "   ", "# #"});
        tiles.put(15, new String[]{"# #", "   ", "# #"});
        tiles.put(19, new String[]{"#-#", "   ", "#-#"});
        tiles.put(28, new String[]{"# #", "| |", "# #"});
    }

    private class Loc {
        int x;
        int y;

        public Loc(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

